<?php
namespace Box\Mod\Contabomanager;
use FOSSBilling\InjectionAwareInterface;
use Pimple\Container;

class Service implements InjectionAwareInterface {
    protected $di;
    public function setDi(Container $di): void { $this->di = $di; }
    public function getDi(): ?Container { return $this->di; }

    public function getServiceCustomArea($order) { return 'mod_contabomanager_index.html.twig'; }
    public function create($order) { return ['username' => 'vps' . $order->id, 'password' => bin2hex(random_bytes(8))]; }
    public function testConnection($h, $u, $p, $pt) { return true; }
    public function suspend($o) { return true; }
    public function unsuspend($o) { return true; }
    public function cancel($o) { return true; }
    public function delete($o) { return true; }

    private function _uuid() {
        return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
            mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff),
            mt_rand(0, 0x0fff) | 0x4000, mt_rand(0, 0x3fff) | 0x8000,
            mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff));
    }

    public function getInstances() {
        $s = [
            'client_id' => 'INT-384566',
            'client_secret' => '59bcd3cb-d7a0-45d3-b827-2542cf8676da',
            'api_username' => 'jim@outlook.com.au',
            'api_password' => '!Marcjackson81'
        ];
        $token = $this->_getToken($s);
        if (!$token) return [];
        $ch = curl_init("https://api.contabo.com/v1/compute/instances");
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Authorization: Bearer $token", "x-request-id: " . $this->_uuid(), "Content-Type: application/json"]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $res = json_decode(curl_exec($ch), true);
        $list = $res['data'] ?? [];
        foreach ($list as &$srv) {
            $name = !empty($srv['displayName']) ? $srv['displayName'] : 'No Name';
            $srv['name'] = $name . " (" . ($srv['name'] ?? '') . ")";
            $srv['ip'] = $srv['ipAddresses']['v4'][0]['ip'] ?? 'No IP';
            $srv['status'] = $srv['status'] ?? 'unknown';
        }
        return $list;
    }

    private function _getToken($s) {
        $ch = curl_init("https://auth.contabo.com/auth/realms/contabo/protocol/openid-connect/token");
        $post = ['grant_type' => 'password', 'client_id' => $s['client_id'], 'client_secret' => $s['client_secret'], 'username' => $s['api_username'], 'password' => $s['api_password']];
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/x-www-form-urlencoded"]);
        $res = json_decode(curl_exec($ch), true);
        return $res['access_token'] ?? null;
    }

    public function postAction($id, $action) {
        $s = ['client_id' => 'INT-384566', 'client_secret' => '59bcd3cb-d7a0-45d3-b827-2542cf8676da', 'api_username' => 'jim@outlook.com.au', 'api_password' => '!Marcjackson81'];
        $token = $this->_getToken($s);
        $ch = curl_init("https://api.contabo.com/v1/compute/instances/$id/actions/$action");
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Authorization: Bearer $token", "x-request-id: " . $this->_uuid(), "Content-Type: application/json"]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        return curl_exec($ch);
    }
}
